function [hdata,data,bend,binidx] = syndisthist(varargin)
%This function allows you to calculate a histogram along a 1D synaptic axis
%Synatax:   [idx,dir2,dir3] = synsubidx('dist',4,'prepost',1,'dir1','c:\...','file1','syn.csv','dir2',..,'dir3',..)
%Input:     'dir1' = the directory the the selected channel, e.g., the
%                channel that is used to define the new subclass
%           'file1' = the file that contains the vertices of the channel
%               that is generated by savpivots that will be used to define
%               the new subclass.
%           'dir2' = the directory where the origin dataset from savpivots
%               resides, in most instances, will be same as dir1.
%           'file2' = the origin vertices
%           'dir3' = the directory where the termini dataset resides
%           'file3' = the termini vertices
%           'prepost' = actually really origin or termi, 0 = origin, and 1
%               = termi, default = 0.
%           'bin' = the number of bins in the histogram, default = 200.
%           'blim' = define the bin max and bin mix,[min max] if left out, the
%               bin limits are self defined by the data
%           note: if nothing is entered, you will be prompted to select
%           dir1, dir2, dir3.
%Output:    hdata = the binned distance data
%           data = the raw distance data
%           bend = left bin end
%           binidx = the indexs of the data points within each bin

[dir1,vert,idxprop,ori_vert,termi_vert,bin,blim] = parse(varargin);

%calculate the distance of vert from the origin
data = dddist(vert,ori_vert);
% %calculate the distance of vert from the termini
% tdata = dddist(vert,termi_vert);
% %calculate the distance of origin to termini
% otdata = dddist(ori_vert,termi_vert);
% %now lets find out if the vert is left or right of the orthoganal axis to
% %the ori-termi axis.  If a^2+b^2>c^2 it is left of ori, and a^2+b^2<c^2 is
% %right of the ori.
% lridx = data.^2+tdata.^2 > otdata.^2;   %everthing left of ori
% lr = ones(size(lridx));     %left right modification array
% lr(lridx) = -1;     %set
% ambidx = data.^2+tdata.^2 ~= otdata.^2;     %if the third point is at the right angle, it is completely ambiguous, remove
% %now make sure the distance is at the correct location
% data = data.*lr;     %flip to proper side
% data = data(ambidx,:);    %remove

% %now do the histogram
% [hdata] = hist(data,bin);

[dvert] = syn_align(ori_vert,termi_vert,vert);  %rotate
fvert = flat_verts(dvert{1},0);   %flat verts, no nan out

%now its simple to find the left right index
lridx = fvert(:,1)<0;
lr = ones(size(lridx));     %left right modification array
lr(lridx) = -1;     %set
ambidx = fvert(:,1)~=0;     %if the third point is at the right angle, it is completely ambiguous, remove
%now make sure the distance is at the correct location
data = data.*lr;     %flip to proper side
data = [data idxprop];  %now add on the properties
data = data(ambidx,:);  %remove

%generate histogram data
[hdata,bend,binidx] = myhist(data,bin,blim);


%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dir1,vert,idxprop,ori_vert,termi_vert,bin,blim] = parse(input)

dir1 = [];
dir2 = [];      %we will assume dir2 is the same as dir3, most likely true. 
dir3 = [];
file1 = [];
file2 = [];
file3 = [];
bin = 200;
blim = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'file2'
                    file2 = input{1,i+1};
                case 'dir1'
                    dir1 = input{1,i+1};
                case 'file1'
                    dir1 = input{1,i+1};
                case 'dir2'
                    dir2 = input{1,i+1};
                case 'dir3'
                    dir3 = input{1,i+1};
                case 'file3'
                    file3 = input{1,i+1};
                case 'bin'
                    bin = input{1,i+1};
                case 'blim'
                    blim = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(dir1)||isempty(file1)    %no directory or vertices file entered
    [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the vertices file','Multiselect','off');
end
vert = single(dlmread([dir1,file1],',',1,0));    %open the file
vert = vert(:,1:3);     %three amigos
%now open the properties files for these vertices, this is all in the
%environment setup by the savpivots
dir_info = dir(dir1);   %grab the file info from dir2
%pull out the channel name
stridx = file1=='_';
stridx = find(stridx==1);   %the second '_' is the one
propfile = pullfile(dir_info,file1(7:stridx(2)-1));   %pull the file
%open the prop file
idxprop = single(dlmread([dir1,propfile],',',1,0));

%now check if dir2 and 3 are entered
if isempty(dir2)||isempty(file2)   %vert mode will generate it's own dir2
    [file2,dir2,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the origin vertices file','Multiselect','off');
end
ori_vert = single(dlmread([dir2,file2],',',1,0));    %open the file
ori_vert = ori_vert(:,1:3);     %just the first three

if isempty(dir3)||isempty(file3)
    [file3,dir3,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the termini vertices file','Multiselect','off');
end
termi_vert = single(dlmread([dir3,file3],',',1,0));    %open the file
termi_vert = termi_vert(:,1:3);     %dri

%--------------------------------------------------------------------------
%subfunction pull properties file
function [filename] = pullfile(dir_struct,matchstr)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    if strcmp('aprop',list{j}(1:5)) %first step, prefered
        if strcmp(list{j}(7:end-4),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
    if strcmp('prop',list{j}(1:4)) %first step, but ok
        if strcmp(list{j}(7:end-4),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
end